<?php

class AkcjaController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->menu;
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('update','admin','updateAction','createChildAction','view'),  // usunieto create ,delete 
				'roles'=>array('admin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model = $this->loadModel($id);

		//only for roots
		if(!empty($model->idRodzica))
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$this->render('view', array(
			'model'=>$model,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Akcja;

		if(isset($_POST['Akcja']))
		{
			$model->attributes = $_POST['Akcja'];

			if($model->save())
				$this->redirect(array('update', 'id'=>$model->id));
		}

		$this->render('create', array(
			'model'=>$model,
			'interiors'=>Akcja::getInteriors()
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreateChildAction($parentId)
	{
		$model = new Akcja;
		$parentModel = $this->loadModel($parentId);
		$rootModel = $parentModel->getRoot();

		if(isset($_POST['Akcja']))
		{
			$model->attributes = $_POST['Akcja'];
			$model->idRodzica = $parentId;
			$model->idLekcji = $parentModel->idLekcji;

			if($model->save())
				$this->redirect(array('update', 'id'=>$rootModel->id));
		}

		$this->render('createChildAction', array(
			'model'=>$model,
			'rootModel'=>$rootModel,
			'parentModel'=>$parentModel,
			'interiors'=>Akcja::getInteriors()
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
/*
		if(isset($_POST['Lekcja']))
		{
			$model->attributes = $_POST['Lekcja'];

			if($model->save())
				$this->redirect(array('view', 'id'=>$model->id));
		}*/

		$this->render('update',array(
			'model'=>$model,
			'interiors'=>Akcja::getInteriors()
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdateAction($id)
	{
		$model = $this->loadModel($id);

		$rootModel = $model->getRoot();

		if(isset($_POST['Akcja']))
		{
			$model->attributes = $_POST['Akcja'];

			if($model->save())
				$this->redirect(array('update', 'id'=>$rootModel->id));
		}

		$this->render('updateAction',array(
			'model'=>$model,
			'rootModel'=>$rootModel,
			'interiors'=>Akcja::getInteriors()
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$model = $this->loadModel($id);
			$rootModel = $model->getRoot();
			$model->deleteChildren();

			$model = Akcja::model()->findByPk($rootModel->id);
			if(empty($model))
				$this->redirect(array('admin'));

			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('update','id'=>$rootModel->id));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Akcja('search');
		$model->unsetAttributes();

		if(isset($_GET['Akcja']))
			$model->attributes = $_GET['Akcja'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Akcja::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		return $model;
	}
}